% compute and plot the unconditional autocorrelations of the actual data 
% and those of the endogenous varaibles generated by the model 
% 10-period horizon.
% load dynare simulation outputs
% needs acfcomp.m and autocov.m

clear; close all;

load usdata_47q1_17q4_unscaled;

%load dynare simulation outputs from the current directory
load ../NK/NK_financial_results;
oo1=oo_;
load ../GK/GK_financial_results;
oo2=oo_;
load ../BGG/BGG_financial_results;
oo3=oo_;

%ACFs of data dy pinfobs obs - sample periods 84:1-08:2
acfy=acfcomp(dyobs(148:245));
acfpi=acfcomp(pinfobs(148:245));
acfr=acfcomp(robs(148:245));

%use the first 10 periods
acfy=acfy([2: 11],:);
acfpi=acfpi([2: 11],:);
acfr=acfr([2: 11],:);

%extract fields from Dynare outputs that contain the ACF estimates 
autocorr1 = [];
autocorr2 = [];
autocorr3 = [];
    for i=1:options_.ar
      autocorr1 = [ autocorr1 diag(oo1.autocorr{i}) ];
      autocorr2 = [ autocorr2 diag(oo2.autocorr{i}) ]; 
      autocorr3 = [ autocorr3 diag(oo3.autocorr{i}) ]; 
    end

%set 10-period horizon.
lag = (1:1:10);

%now I plot ACFs
F1=figure(1);
subplot(2,2,1)
set(F1, 'numbertitle','off')
set(F1, 'name', 'ACFs - NK Models')
plot(lag,acfy,'-.k','linewidth',2)
hold on
plot(lag,autocorr1(1,:)','-or','linewidth',1)
plot(lag,autocorr2(1,:)','-db','linewidth',1)
plot(lag,autocorr3(1,:)','-sg','linewidth',1)
hold off
title('Output')


subplot(2,2,2)
plot(lag,acfpi,'-.k','linewidth',2)
hold on
plot(lag,autocorr1(2,:)','-or','linewidth',1)
plot(lag,autocorr2(2,:)','-db','linewidth',1)
plot(lag,autocorr3(2,:)','-sg','linewidth',1)
hold off
title('Inflation')

subplot(2,2,3)
plot(lag,acfr,'-.k','linewidth',2)
hold on
plot(lag,autocorr1(3,:)','-or','linewidth',1)
plot(lag,autocorr2(3,:)','-db','linewidth',1)
plot(lag,autocorr3(3,:)','-sg','linewidth',1)
hold off
title('Interest rate')

%define legend
legend('data','Model NK','Model GK','Model BGG');
